<?php
// Retorna JSON sempre
header('Content-Type: application/json; charset=utf-8');
require __DIR__ . '/config.php';
session_start();

// Aceita a placa da sessão (consulta em uso) ou do GET (para testes isolados)
$placa = $_SESSION['placa'] ?? ($_GET['placa'] ?? '');
$placa = trim($placa);

if ($placa === '') {
    http_response_code(400);
    echo json_encode(['erro' => 'Placa não informada.']);
    exit;
}

$dados = chamarApiPosicaoFila($placa);
if (!$dados) {
    http_response_code(502);
    echo json_encode(['erro' => 'Falha na comunicação com a API.']);
    exit;
}

// Normaliza resposta (mantém compatível com seu TS)
echo json_encode($dados, JSON_UNESCAPED_UNICODE);
