<?php
// Configurações da API (mantém o token no servidor)
const API_URL = "http://200.150.120.54:9090/attmonitor/api/posicao_fila_filiais.php";
const API_TOKEN = "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJodHRwOlwvXC9leGFtcGxlLm9yZyIsImF1ZCI6Imh0dHA6XC9cL2V4YW1wbGUuY29tIiwiaWF0IjoxMzU2OTk5NTI0LCJuYmYiOjEzNTcwMDAwMDAsImRhdGEiOnsibm9tZV9jb21wbGV0byI6IkFVVE9VU0VSIiwiZW1wcmVzYV9ncnVwbyI6IkFUVCIsImlkX25pdmVsIjoiNDAiLCJpZF9ub21lIjoiQVVUT1VTRVIifX0.uPj6t1cfiTjCCvPdT3OgV5se3ZNy0CH6XbvE0MV7vfs";

function chamarApiPosicaoFila(string $placa): ?array {
    $payload = [
        "AttApi" => [
            "tipoOperacao" => "d_posicao_fila",
            "veiculo"      => mb_strtoupper($placa, 'UTF-8'),
        ]
    ];

    $ch = curl_init(API_URL);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST           => true,
        CURLOPT_HTTPHEADER     => [
            "Content-Type: application/json",
            "token: " . API_TOKEN
        ],
        CURLOPT_POSTFIELDS     => json_encode($payload, JSON_UNESCAPED_UNICODE),
        CURLOPT_TIMEOUT        => 15,
    ]);

    $res = curl_exec($ch);
    $err = curl_error($ch);
    $http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($err || $http >= 400) {
        return null;
    }

    $data = json_decode($res, true);
    return is_array($data) ? $data : null;
}

function formatarDataBr(?string $yyyy_mm_dd): string {
    if (!$yyyy_mm_dd) return "-";
    [$y,$m,$d] = explode('-', $yyyy_mm_dd);
    return sprintf("%02d/%02d/%04d", (int)$d,(int)$m,(int)$y);
}



// ==================== CONFIG Z-API ====================
const ZAPI_INSTANCE_ID   = "3E56B4CDFAD31155CCAB4E503A85D2DF";
const ZAPI_INSTANCE_TOKEN = "F775BAA6AC73842BA7809A8B";
const ZAPI_CLIENT_TOKEN   = "F8f168eabb079408c9c23fa1a811416d9S"; // gere no painel da Z-API

/**
 * Envia mensagem de texto via Z-API para um número de WhatsApp
 *
 * @param string $numero Número no formato 55DDDXXXXXXXX (somente números)
 * @param string $mensagem Texto da mensagem
 * @return bool True se enviado com sucesso, false caso contrário
 */
function enviarWhatsApp(string $numero, string $mensagem): bool {
    $url = "https://api.z-api.io/instances/" . ZAPI_INSTANCE_ID . "/token/" . ZAPI_INSTANCE_TOKEN . "/send-text";

    $payload = json_encode([
        "phone"   => $numero,
        "message" => $mensagem
    ], JSON_UNESCAPED_UNICODE);

    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST           => true,
        CURLOPT_HTTPHEADER     => [
            "Content-Type: application/json",
            "Client-Token: " . ZAPI_CLIENT_TOKEN
        ],
        CURLOPT_POSTFIELDS     => $payload,
        CURLOPT_TIMEOUT        => 15,
    ]);

    $res = curl_exec($ch);
    $err = curl_error($ch);
    $http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($err || $http >= 400) {
        error_log("Erro ao enviar WhatsApp: " . $err . " HTTP: " . $http);
        return false;
    }

    $data = json_decode($res, true);
    return isset($data["messageId"]);
}