<?php
session_start();
if (!empty($_SESSION['placa'])) {
  header("Location: resultado");
  exit;
}
$erro = $_GET['erro'] ?? '';
unset($_SESSION['flash_erro']);
?>
<!doctype html>
<html lang="pt-br">
<head>
  <meta charset="utf-8">
  <title>Consulta de Fila</title>
  <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover">
  <meta name="theme-color" content="#0b2d55">
  <link rel="stylesheet" href="assets/style.css">
  <link rel="icon" type="image/png" href="assets/Logo-ATT2.png">
</head>
<body>
  <main class="wrap">
    <div class="top">
      <img src="assets/Logo-ATT2.png" alt="Grupo ATT" class="brand">

    </div>

    <h1 class="app-title">Consulta de Fila</h1>

    <form class="login-box" method="post" action="resultado" id="form-placa">
  <?php if ($erro): ?>
    <div class="msg-erro" id="msg-erro"><?= htmlspecialchars($erro) ?></div>
  <?php else: ?>
    <div class="msg-erro" id="msg-erro" style="display:none;"></div>
  <?php endif; ?>

  <label for="placa" class="sr-only">Placa</label>
  <input
    id="placa"
    name="placa"
    class="plate-input"
    type="text"
    inputmode="latin"
    autocapitalize="characters"
    autocomplete="off"
    maxlength="8"
    pattern="[A-Za-z0-9]{7,8}"
    placeholder="Digite a placa"
  >

  <button class="cta" type="submit">Consultar</button>

  <div class="footer">© <?= date('Y') ?> Todos os direitos reservados Grupo ATT</div>
</form>

  </main>

  <script>
(function(){
  const form    = document.getElementById('form-placa');
  const input   = document.getElementById('placa');
  const msgErro = document.getElementById('msg-erro');

  // Saneia a cada digitação: A-Z/0-9, maiúscula e no máx. 8
  input.addEventListener('input', () => {
    let v = input.value.toUpperCase().replace(/[^A-Z0-9]/g, '');
    if (v.length > 8) v = v.slice(0, 8);
    input.value = v;
  });

  // Evita digitar além de 8 (sem bloquear backspace, setas, etc.)
  input.addEventListener('keydown', (e) => {
    const allowed = ['Backspace','Delete','ArrowLeft','ArrowRight','Tab','Home','End'];
    if (allowed.includes(e.key) || e.ctrlKey || e.metaKey) return;
    if (input.selectionStart !== input.selectionEnd) return; // há seleção
    if (input.value.length >= 8) e.preventDefault();
  });

  function showError(t){ msgErro.textContent = t; msgErro.style.display = 'block'; }
  function hideError(){ msgErro.textContent = ''; msgErro.style.display = 'none'; }

  form.addEventListener('submit', async (ev) => {
    ev.preventDefault();

    const placa = (input.value || '').toUpperCase().trim();

    // validações locais (formato)
    if (!placa) { showError('Informe a placa.'); return; }
    if (placa.length !== 7 && placa.length !== 8) {
      showError('A placa deve conter 7 ou 8 caracteres.'); return;
    }
    if (!/^[A-Z0-9]+$/.test(placa)) {
      showError('Placa incorreta. Use apenas letras e números.'); return;
    }

    hideError();

    // 🔎 valida no servidor usando o seu próprio api_consulta.php via GET
    try {
      const r = await fetch('api_consulta.php?placa=' + encodeURIComponent(placa), { cache:'no-store' });
      const data = await r.json().catch(() => ({}));

      // se API retornou erro (http 4xx/5xx) ou não veio veiculo
      const veiculo = data?.dados?.dadosVeiculo ?? null;
      if (!r.ok || !veiculo) {
        showError(data?.erro || 'Placa não encontrada na fila no momento.');
        return;
      }

      // ok -> envia form normalmente (grava placa na sessão e vai pra /resultado)
      input.value = placa;
      form.submit();

    } catch (e) {
      showError('Falha ao verificar a placa. Tente novamente.');
    }
  });
})();
</script>

</body>
</html>
